############### ###############
## T_H4_Accuracy
## Project: CBO
## PI: Malte Lierl
## Written by: Malte Lierl
## Date of creation: 2022-11-06
############### ###############

# Hypothesis 4: A_abs_deviation_relative_perf --------------- ###### 

  ## a. Estimation: sum of absolute deviations between decision makers' perception of and the actual municipal performance quintile, averaged across all groups of indicators in 2018 ####
  

  # All respondent types, clustered by municipality
  h4acc.all <- summary(lm_robust(A_abs_deviation_relative_perf ~ treatmentcommune + factor(randomization_block), clusters = region_commune, data=DM_final, weights=DM_weight))
  h4acc.all
  
  # Mayors
  h4acc.mayor <- summary(lm_robust(A_abs_deviation_relative_perf ~ treatmentcommune + factor(randomization_block), data=DM_final %>% filter(respondent_type=="Mayor"), weights=DM_weight, se_type="HC3"))
  h4acc.mayor
  
  # Deputy Mayors
  h4acc.deputy <- summary(lm_robust(A_abs_deviation_relative_perf ~ treatmentcommune + factor(randomization_block), data=DM_final %>% filter(respondent_type=="Deputy Mayor"), weights=DM_weight, se_type="HC3"))
  h4acc.deputy
  
  # Opposition Leaders
  h4acc.opposition <- summary(lm_robust(A_abs_deviation_relative_perf ~ treatmentcommune + factor(randomization_block), data=DM_final %>% filter(respondent_type=="Opposition Member"), weights=DM_weight, se_type="HC3"))
  h4acc.opposition
  
  # Secretary General
  h4acc.sg <- summary(lm_robust(A_abs_deviation_relative_perf ~ treatmentcommune + factor(randomization_block), data=DM_final %>% filter(respondent_type=="Secretary General"), weights=DM_weight, se_type="HC3"))
  h4acc.sg
  
  # Number of clusters for h4acc.all
  h4acc.all.clusters <- DM_final %>% drop_na(A_breadth_awareness_sm_indicators) %>% distinct(commune) %>% nrow

  # Function to output control group mean
  cgmean <- function(x, digits=3) {
    cg <- x %>% filter(treatmentcommune==0) %>%  drop_na(A_abs_deviation_relative_perf) 
    signif(wtd.mean(cg$A_abs_deviation_relative_perf, weights=cg$DM_weight, na.rm=TRUE), digits=digits)
  }
  
  ## b. Write table ## 
  
  tex("
        \\begin{tabularx}{\\textwidth}{l X X X X X}
        \\hline
        & \\multicolumn{5}{c}{\\emph{DV: Sum of absolute deviations between decision makers' perception of }}\\\\
        & \\multicolumn{5}{c}{\\emph{and the actual municipal performance quintile}} \\\\
        \\\\
        & (1) & (2) & (3) & (4) & (5) \\\\
        &  All & Mayors & Deputy Mayors & Opposition Leaders & Secretary General \\\\
        \\hline 
        \\\\
        Control group mean & <<cgmean(DM_final)>> & <<cgmean(DM_final %>% filter(respondent_type=='Mayor'))>> & <<cgmean(DM_final %>% filter(respondent_type=='Deputy Mayor'))>> & <<cgmean(DM_final %>% filter(respondent_type=='Opposition Member'))>> & <<cgmean(DM_final %>% filter(respondent_type=='Secretary General'))>> \\\\
        \\\\
        Treatment & <<stars(x=h4acc.all,v='treatmentcommune',digits=3)>> & <<stars(h4acc.mayor,'treatmentcommune',3)>> & <<stars(h4acc.deputy,'treatmentcommune',3)>> & <<stars(h4acc.opposition,'treatmentcommune',3)>> & <<stars(h4acc.sg,'treatmentcommune',3)>> \\\\
        & (<<se(h4acc.all,'treatmentcommune',3)>>) & (<<se(h4acc.mayor,'treatmentcommune',3)>>) & (<<se(h4acc.deputy,'treatmentcommune',3)>>) & (<<se(h4acc.opposition,'treatmentcommune',3)>>) & (<<se(h4acc.sg,'treatmentcommune',3)>>) \\\\
        \\\\
        \\hline
        Observations & <<h4acc.all$nobs>> & <<h4acc.mayor$nobs>> & <<h4acc.deputy$nobs>> & <<h4acc.opposition$nobs>> & <<h4acc.sg$nobs>> \\\\
        Clusters (Municipalities) & <<h4acc.all.clusters>>  & & & & \\\\
        \\hline \\hline
        \\end{tabularx}
    \\footnotesize{Average treatment effects estimated via OLS regression with fixed effects for randomization blocks. Column (1): Cluster-robust standard errors in parentheses. Columns (2)-(5): HC3 standard errors in parentheses. $^{*} p<0.1$, $^{**} p<0.05$, $^{***} p<0.01$ (two-sided). }
    ", 
      file = here('Output/For Publication/Tables/T_H4_Accuracy.tex'))
  

